-- This file contains an example of a HelpText that does things between
-- switching tips, unlike the default HelpDisplay which abruptly changes them.
-- This also will not fade on a single tip as that's kinda pointless.

-- The problem with using it, however, is that it makes PlayerOptions take
-- absolutely FOREVER to load. I am not sure why, so I have disabled it
-- for the time being. I guess if you use OptionsList in your theme, this
-- could be of use to you.

local tips = split( "::", ScreenString("HelpText") );
local numTips = #tips;
local i = 1;

local t = Def.ActorFrame{
	-- bg quad added in 1.3
	Def.Quad{
		InitCommand=cmd(y,1;zoomto,SCREEN_WIDTH,32;diffuse,color("0,0,0,0.5");diffusetopedge,color("0,0,0,0.2"));
	};
	
	LoadActor( THEME:GetPathB("","_frame 3x3"), "_rounded normal", SCREEN_CENTER_X, 1)..{
		InitCommand=cmd(diffuse,0.5,0.5,0.5,0.8);
		OnCommand=cmd(linear,0.2;diffusealpha,1);
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};
	--[[
	LoadFont("_frutiger lt std 55 roman 24px")..{
		Name="HelpText";
		InitCommand=cmd(shadowlength,0;zoom,0.6);
		OnCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			-- if numTips is 1, settext and return early,
			-- there's no sense in fading a single tip.
			if numTips == 1 then self:settext(tips[1]); return; end;
			
			-- check iterator so we can wrap around.
			if i > numTips then i = 1; end;
			
			-- fade in for 0.25 seconds
			self:linear(0.25);
			self:diffusealpha(1);
			
			--set the text
			self:settext(tips[i]);
			
			-- sleep for 3 seconds.
			self:sleep(3);
			
			-- fade out for 0.25 seconds
			self:linear(0.25);
			self:diffusealpha(0);
			
			-- increment i
			i = i + 1;
			
			self:queuecommand("Set");
		end;
		OffCommand=cmd(linear,0.2;diffusealpha,0);
	};
	]]
};

return t;
-- remember: the devil's in the details. -AJ